/*
 * Decompiled with CFR 0.152.
 */
package tv.icntv.ottlogin;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import konka.AidlHelper;
import robot.RobotID;
import tv.icntv.ottlogin.MD5;
import tv.icntv.ottlogin.TransferData;
import tv.icntv.ottlogin.utils;

public class loginSDK {
    public static final int TYPE_COMMON = 0;
    public static final int TYPE_KONKA = 1;
    public static final int TYPE_ROBOT = 2;
    public static final int TYPE_KONKA_MIGU = 3;
    public static final int TYPE_SONY = 4;
    private static final String LOG_TAG = "ottlogin";
    private static final String DEVICE_UPDATE_SERVER = "APP_UPDATE";
    private static final int BUFFER_SIZE_64 = 64;
    private static final String VERSION = "V5.0.17";
    private static final String SO_NAME = "ottlogin";
    private static final String SONY_MODELNAME = "getprop ro.svp.modelname";
    private static final String SONY_SERIALNO = "getprop ro.serialno";
    private static final int SONY_SN_LENGTH = 12;
    private static final String SONY_SN_SUFFIX = "-999";
    private static loginSDK mInstance = null;
    private static boolean mIsLibraryLoadOk = false;
    private String mLicense = null;
    private Context mContext;
    private String mTMSServerUrl;
    private String mAppKey;
    private String mChannelCode;
    private String mAppSecret;

    static {
        try {
            System.loadLibrary("ottlogin");
            mIsLibraryLoadOk = true;
        }
        catch (Throwable e) {
            Log.e((String)"ottlogin", (String)"system ottlogin load error, please check .so name and .so is exist?");
        }
    }

    private loginSDK() {
    }

    public static synchronized loginSDK getInstance() {
        if (mInstance == null) {
            mInstance = new loginSDK();
        }
        return mInstance;
    }

    private String startRunTime(String cmd) throws Exception {
        Log.d((String)"ottlogin", (String)("startRunTime cmd: " + cmd));
        Process p = Runtime.getRuntime().exec(cmd);
        InputStream is = p.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String result = null;
        String line = null;
        line = reader.readLine();
        if (line != null) {
            result = line;
            Log.d((String)"ottlogin", (String)("startRunTime result: " + result));
        }
        p.waitFor();
        is.close();
        reader.close();
        p.destroy();
        return result;
    }

    private synchronized native boolean init(String var1, String var2, String var3, String var4, String var5);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean sdkInit(int type, String channelCode, String appKey, String appSecret, Context context) {
        Log.i((String)"ottlogin", (String)"ottlogin jar VERSION: V5.0.17");
        if (context == null) {
            Log.e((String)"ottlogin", (String)"context is null");
            return false;
        }
        String configurePath = context.getFilesDir().getAbsolutePath();
        this.setDNSServers(context);
        utils.createDir(String.valueOf(configurePath) + "/ini");
        if (!mIsLibraryLoadOk) {
            Log.e((String)"ottlogin", (String)"ottlogin load fail, can't login!");
            return false;
        }
        Log.i((String)"ottlogin", (String)("-->>appkey:" + appKey + "-->>channelCode:" + channelCode + "-->>appSecret:" + appSecret));
        if (type == 0) {
            this.mLicense = null;
            return this.init(configurePath, this.mLicense, channelCode, appKey, appSecret);
        }
        if (type == 1) {
            if (this.mLicense != null) {
                if (this.mLicense != "") return this.init(configurePath, this.mLicense, channelCode, appKey, appSecret);
            }
            AidlHelper aidlhelper = new AidlHelper(context);
            this.mLicense = aidlhelper.getCNTV4License();
            aidlhelper.destroy();
            if (this.mLicense != null) {
                if (this.mLicense != "") return this.init(configurePath, this.mLicense, channelCode, appKey, appSecret);
            }
            Log.e((String)"ottlogin", (String)"loginSDK sdkInit getCNTV4License failed");
            return false;
        }
        if (type == 2) {
            if (this.mLicense != null) {
                if (this.mLicense != "") return this.init(configurePath, this.mLicense, channelCode, appKey, appSecret);
            }
            this.mLicense = RobotID.getRobotId(context);
            if (this.mLicense != null) {
                if (this.mLicense != "") return this.init(configurePath, this.mLicense, channelCode, appKey, appSecret);
            }
            Log.e((String)"ottlogin", (String)"loginSDK sdkInit getRobotId failed");
            return false;
        }
        if (type == 3) {
            if (this.mLicense != null) {
                if (this.mLicense != "") return this.init(configurePath, this.mLicense, channelCode, appKey, appSecret);
            }
            AidlHelper aidlhelper = new AidlHelper(context);
            this.mLicense = aidlhelper.getCNTV5License();
            aidlhelper.destroy();
            if (this.mLicense != null) {
                if (this.mLicense != "") return this.init(configurePath, this.mLicense, channelCode, appKey, appSecret);
            }
            Log.e((String)"ottlogin", (String)"loginSDK sdkInit getCNTV5License failed");
            return false;
        }
        if (type != 4) {
            this.mLicense = null;
            return this.init(configurePath, this.mLicense, channelCode, appKey, appSecret);
        }
        if (this.mLicense != null) {
            if (this.mLicense != "") return this.init(configurePath, this.mLicense, channelCode, appKey, appSecret);
        }
        try {
            String serialno;
            if (Build.VERSION.SDK_INT >= 28) {
                Log.i((String)"ottlogin", (String)("\u7248\u672c\u53f7\u4e3a\uff1a" + Build.VERSION.RELEASE + "\u91c7\u7528api\u83b7\u53d6\u5e8f\u5217\u53f7"));
                String modelname = Build.MODEL;
                if (modelname == null || modelname.length() == 0) {
                    Log.e((String)"ottlogin", (String)"loginSDK sdkInit sony get modelname failed");
                    return false;
                }
                String serialnoUsed = Build.getSerial();
                if (serialnoUsed != null && serialnoUsed.length() != 0) {
                    Log.d((String)"ottlogin", (String)("modelnameUsed: " + modelname + ", serialnoUsed: " + serialnoUsed));
                    this.mLicense = (String.valueOf(modelname) + serialnoUsed).replaceAll(" ", "").toUpperCase();
                    Log.i((String)"ottlogin", (String)("Sony license is " + this.mLicense));
                    return this.init(configurePath, this.mLicense, channelCode, appKey, appSecret);
                }
                Log.e((String)"ottlogin", (String)"loginSDK sdkInit sony get serialno failed");
                return false;
            }
            String modelname = this.startRunTime(SONY_MODELNAME);
            if (modelname == null || modelname.length() == 0) {
                Log.e((String)"ottlogin", (String)"loginSDK sdkInit sony get modelname failed");
                return false;
            }
            if (Build.VERSION.SDK_INT >= 26) {
                Log.i((String)"ottlogin", (String)("\u7248\u672c\u53f7\u4e3a\uff1a" + Build.VERSION.RELEASE + "\u91c7\u7528api\u83b7\u53d6\u5e8f\u5217\u53f7"));
                serialno = Build.getSerial();
            } else {
                Log.i((String)"ottlogin", (String)("\u7248\u672c\u53f7\u4e3a\uff1a" + Integer.toString(Build.VERSION.SDK_INT) + "\u91c7\u7528cmd\u83b7\u53d6\u5e8f\u5217\u53f7"));
                serialno = this.startRunTime(SONY_SERIALNO);
            }
            if (serialno != null && serialno.length() != 0) {
                String modelnameUsed = modelname.toUpperCase();
                String serialnoUsed = serialno.substring(serialno.length() - 7, serialno.length());
                Log.d((String)"ottlogin", (String)("modelnameUsed: " + modelnameUsed + ", serialnoUsed: " + serialnoUsed));
                String sn = String.valueOf(MD5.encrypt(modelnameUsed)) + serialnoUsed;
                Log.d((String)"ottlogin", (String)("sn: " + sn));
                this.mLicense = sn.substring(sn.length() - 12, sn.length());
                this.mLicense = String.valueOf(this.mLicense) + SONY_SN_SUFFIX;
                return this.init(configurePath, this.mLicense, channelCode, appKey, appSecret);
            }
            Log.e((String)"ottlogin", (String)"loginSDK sdkInit sony get serialno failed");
            return false;
        }
        catch (Exception e) {
            Log.e((String)"ottlogin", (String)"loginSDK sdkInit sony get sn failed");
            e.printStackTrace();
            this.mLicense = null;
            return false;
        }
    }

    public native boolean sdkExit();

    private native String sdkDeviceLogin();

    public String deviceLogin() {
        String respone = this.sdkDeviceLogin();
        return respone;
    }

    public native String getLoginStatus();

    public native String loginStatusToMsg(String var1);

    private native int getDeviceID(TransferData var1);

    public int getDeviceID(StringBuffer deviceID) {
        if (deviceID == null) {
            deviceID = new StringBuffer();
        }
        deviceID.delete(0, deviceID.length());
        TransferData id = new TransferData();
        int val = this.getDeviceID(id);
        if (id != null && id.getResult() != null) {
            deviceID.append(id.getResult());
        } else {
            deviceID.append("");
        }
        return val;
    }

    private native int getUserID(TransferData var1);

    public int getUserID(StringBuffer userID) {
        if (userID == null) {
            userID = new StringBuffer();
        }
        userID.delete(0, userID.length());
        TransferData id = new TransferData();
        int val = this.getUserID(id);
        if (id != null && id.getResult() != null) {
            userID.append(id.getResult());
        } else {
            userID.append("");
        }
        return val;
    }

    private native int getTemplateID(TransferData var1);

    public int getTemplateID(StringBuffer templateID) {
        if (templateID == null) {
            templateID = new StringBuffer();
        }
        templateID.delete(0, templateID.length());
        TransferData id = new TransferData();
        int val = this.getTemplateID(id);
        if (id != null && id.getResult() != null) {
            templateID.append(id.getResult());
        } else {
            templateID.append("");
        }
        return val;
    }

    private native int getPlatformID(TransferData var1);

    public int getAppKey(StringBuffer platformID) {
        if (platformID == null) {
            platformID = new StringBuffer();
        }
        platformID.delete(0, platformID.length());
        TransferData id = new TransferData();
        int val = this.getPlatformID(id);
        if (id != null && id.getResult() != null) {
            platformID.append(id.getResult());
        } else {
            platformID.append("");
        }
        return val;
    }

    private native int getToken(TransferData var1);

    public int getToken(StringBuffer token) {
        if (token == null) {
            token = new StringBuffer();
        }
        token.delete(0, token.length());
        TransferData id = new TransferData();
        int val = this.getToken(id);
        if (id != null && id.getResult() != null) {
            token.append(id.getResult());
        } else {
            token.append("");
        }
        return val;
    }

    private native int getServerAddress(String var1, TransferData var2);

    public int getServerAddress(String name, StringBuffer serverAddr) {
        if (serverAddr == null) {
            serverAddr = new StringBuffer();
        }
        serverAddr.delete(0, serverAddr.length());
        TransferData dataVal = new TransferData();
        int val = this.getServerAddress(name, dataVal);
        if (dataVal != null && dataVal.getResult() != null) {
            serverAddr.append(dataVal.getResult());
        } else {
            serverAddr.append("");
        }
        return val;
    }

    private native int getStbext(TransferData var1);

    public int getSTBext(StringBuffer data) {
        if (data == null) {
            data = new StringBuffer();
        }
        data.delete(0, data.length());
        TransferData buf = new TransferData();
        int val = this.getStbext(buf);
        if (buf != null && buf.getResult() != null) {
            data.append(buf.getResult());
        } else {
            data.append("");
        }
        return val;
    }

    private native int getVersion(TransferData var1);

    public int getVersion(StringBuffer version) {
        if (version == null) {
            version = new StringBuffer();
        }
        version.delete(0, version.length());
        TransferData vers = new TransferData();
        int val = this.getVersion(vers);
        if (vers != null && vers.getResult() != null) {
            version.append(vers.getResult());
        } else {
            version.append("");
        }
        return val;
    }

    public native int logUpload();

    public native int bootGuide();

    private native int getValueByKey(String var1, TransferData var2);

    public int getValueByKey(String key, StringBuffer value) {
        if (value == null) {
            value = new StringBuffer();
        }
        value.delete(0, value.length());
        TransferData dataVal = new TransferData();
        int val = this.getValueByKey(key, dataVal);
        if (dataVal != null && dataVal.getResult() != null) {
            value.append(dataVal.getResult());
        } else {
            value.append("");
        }
        return val;
    }

    public native void setValueByKey(String var1, String var2);

    private void setDNSServers(Context context) {
        String deviceDnsServers = utils.getDnsServers(context);
        if (deviceDnsServers == null || deviceDnsServers.length() <= 0) {
            Log.i((String)"ottlogin", (String)"getDnsServers return null.");
        } else {
            this.setValueByKey("DNS_SERVER_ARRRESS", deviceDnsServers);
        }
    }

    public native void setLogOpen(boolean var1);
}

