/*
 * Decompiled with CFR 0.152.
 */
package tv.icntv.ottlogin;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.os.Build;
import android.util.Log;
import java.io.File;
import java.net.InetAddress;
import java.util.List;

public class utils {
    private static final String TAG = "ottlogin_utils";

    public static String getDnsServers(Context context) {
        String DNSServers = null;
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            if (Build.VERSION.SDK_INT >= 26) {
                Network an = connectivityManager.getActiveNetwork();
                LinkProperties lp = connectivityManager.getLinkProperties(an);
                List dns = lp.getDnsServers();
                Log.d((String)TAG, (String)("iface = " + lp.getInterfaceName()));
                Log.d((String)TAG, (String)("dns = " + lp.getDnsServers().toString()));
                for (InetAddress ia : dns) {
                    String ha = ia.getHostAddress();
                    Log.d((String)TAG, (String)("hostAddress is " + ha));
                    DNSServers = DNSServers != null ? String.valueOf(DNSServers) + "," + ha : ha;
                }
                return DNSServers;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception throw " + e.getMessage()));
        }
        return "";
    }

    public static boolean createDir(String destDirName) {
        File dir = new File(destDirName);
        if (dir.exists()) {
            Log.d((String)"ottlogin", (String)("\u521b\u5efa\u76ee\u5f55" + destDirName + "\u5931\u8d25\uff0c\u76ee\u6807\u76ee\u5f55\u5df2\u7ecf\u5b58\u5728"));
            return false;
        }
        if (!destDirName.endsWith(File.separator)) {
            destDirName = String.valueOf(destDirName) + File.separator;
        }
        if (dir.mkdirs()) {
            Log.d((String)"ottlogin", (String)("\u521b\u5efa\u76ee\u5f55" + destDirName + "\u6210\u529f\uff01"));
            return true;
        }
        Log.d((String)"ottlogin", (String)("\u521b\u5efa\u76ee\u5f55" + destDirName + "\u5931\u8d25\uff01"));
        return false;
    }
}

